/*
 * --COPYRIGHT--,BSD Copyright (c) 2015, Texas Instruments Incorporated
 * All rights reserved. Redistribution and use in source and binary
 * forms, with or without modification, are permitted provided that the
 * following conditions are met: * Redistributions of source code must
 * retain the above copyright notice, this list of conditions and the
 * following disclaimer. * Redistributions in binary form must reproduce
 * the above copyright notice, this list of conditions and the following
 * disclaimer in the documentation and/or other materials provided with
 * the distribution. * Neither the name of Texas Instruments Incorporated 
 * nor the names of its contributors may be used to endorse or promote
 * products derived from this software without specific prior written
 * permission. THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE. --/COPYRIGHT--
 */


#include <msp430.h>
#include "utility.h"
#include "Sinewave_values.h"



#pragma vector= DAC12_VECTOR, DMA_VECTOR, USCIAB1TX_VECTOR, USCIAB1RX_VECTOR, \
	            PORT1_VECTOR, PORT2_VECTOR,ADC12_VECTOR, COMPARATORA_VECTOR, \
	            TIMERA0_VECTOR, TIMERB0_VECTOR, NMI_VECTOR
__interrupt void
Trap_ISR(void)
{
}

#pragma vector=TIMERB1_VECTOR
__interrupt void
TimerB1(void)
{
    switch (TBIV) {
    case TBIV_TBCCR1:
	// increment or decrement to the new timer B value
	if (AccelerateState == ACCEL
	    && (SteppingRate <= DesiredTargetSpeed)) {
	    // increase pps and calculate new pps
	    if (SteppingRate + SteppingRateUpdate >= DesiredTargetSpeed) {
		// if (MoveSteps == false && SteppingRate ==
		// DesiredTargetSpeed)
		AccelerateState = RUN;	// No longer accelerate
		SteppingRate = DesiredTargetSpeed;
	    } else {
		SteppingRate += SteppingRateUpdate;	// Increment
		AccelerateState = ACCEL;
	    }
	}
	if (AccelerateState == DECEL) {
	    if (SteppingRate >= StoppingSpeed) {
		// decrease pps and calculate new pps
		if (SteppingRate - SteppingRateUpdate <= StoppingSpeed) {
		    if (MoveSteps == false
			&& SteppingRate == StoppingSpeed)
			AccelerateState = IDLE;	// Stop motor when speed
						// is reached
		    SteppingRate = StoppingSpeed;
		} else {
		    SteppingRate -= SteppingRateUpdate;	// Decrement
		    AccelerateState = DECEL;
		}
	    } else		// already less than stopping speed
	    {
		if (MoveSteps == false)
		    AccelerateState = IDLE;	// Stop motor when speed
						// is reached
	    }
	}
	// this allows for the motor to spin down to new speed without
	// stopping
	if (AccelerateState == DECEL2NEWTARGET) {
	    if (SteppingRate >= DesiredTargetSpeed) {
		// decrease pps and calculate new pps
		if (SteppingRate - SteppingRateUpdate <=
		    DesiredTargetSpeed) {
		    if (SteppingRate == DesiredTargetSpeed)
			AccelerateState = RUN;	// switch to RUN when
						// speed is reached
		    SteppingRate = DesiredTargetSpeed;
		} else {
		    SteppingRate -= SteppingRateUpdate;	// Decrement
		    AccelerateState = DECEL2NEWTARGET;
		}
	    }
	}
	// do not perform the division here -- only update the stepping
	// rate
	// if the stepping rate has been updated, set a flag
	if (SteppingRate != PriorSteppingRate) {
	    UpdateSteppingRateTMR = true;	// Set flag to
						// re-calculate stepping
						// rate TMR
	    PriorSteppingRate = SteppingRate;
	}
	break;
    case TBIV_TBCCR2:
	break;
    case TBIV_TBCCR3:
	break;
    case TBIV_TBCCR4:
	break;
    case TBIV_TBCCR5:
	break;
    case TBIV_TBCCR6:
	break;
    case TBIV_TBIFG:
	break;
    }
}

#pragma vector=TIMERA1_VECTOR
__interrupt void
TimerA1(void)
{
    switch (TAIV) {
    case TAIV_TACCR1:
	break;
    case TAIV_TACCR2:
	if (MoveSteps)		// if manual advance count steps
	{			// when complete
	    tmpStepsToMove++;	// increment step counter
	    if (tmpStepsToMove >= Steps2Decel) {
		AccelerateState = DECEL;	// start deceleration
	    }
	    // if (tmpStepsToMove >= StepsToMove) // stop here when equal
	    if (tmpStepsToMove > StepsToMove)	// stop here when greater
						// than
		// normally it is >= but because the DAC changes to
		// advance
		// let it run through one more time
	    {
		AccelerateState = IDLE;
		temp_reciprocation = false;
		if ((G_RECIPROCATION == true) && (temp_delay == false)) {
		    if (G_DIR == high)	// change direction when finished
					// the steps
		    {
			G_DIR = low;
		    } else
			G_DIR = high;
		    temp_delay = true;
		}
		if (G_RECIPROCATION == false) {
		    if (last_reciprocation_state == 1) {

			if (G_DIR == high)	// reverse the direction
						// when the motor is
						// stopped
			{
			    G_DIR = low;
			} else
			    G_DIR = high;
			last_reciprocation_state = 0;
		    }
		    // TACTL &= ~MC_3; // Stop timerA
		    // TBCTL &= ~MC_3; // Stop timerB
		    MoveSteps = false;
		}
		TACTL &= ~MC_3;	// Stop timerA
		TBCTL &= ~MC_3;	// Stop timerB
	    }

	}
	// if motor is still running advance
	// if the motor state machine is not idle and move_to_next_step is 
	// one,
	// advance the sinewave table
	if (AccelerateState != IDLE) {
	    // calculate next value and adjust for over/underflow
	    if (G_DIR == low) {
		Next_a_step += step_offset;
		if (Next_a_step > 2047)
		    Next_a_step &= 2047;
		Next_b_step += step_offset;
		if (Next_b_step > 2047)
		    Next_b_step &= 2047;
	    } else {
		Next_a_step -= step_offset;
		if (Next_a_step > 2048)
		    Next_a_step &= 2047;
		Next_b_step -= step_offset;
		if (Next_b_step > 2048)
		    Next_b_step &= 2047;
	    }
	    // if STEP_MODE has changed, align values to
	    // proper steps
	    // this is done by masking the lower values
	    if (temp_step_mode > 1) {
		Next_a_step &= (0x7ff << (10 - temp_step_mode));
		Next_b_step &= (0x7ff << (10 - temp_step_mode));
	    } else if (temp_step_mode == 0) {	// align to 200 hex then
						// change to odd
		Next_a_step &= (0x7ff << 9);
		Next_a_step |= BIT8;	// align to odd 100 hex
		Next_b_step &= (0x7ff << 9);
		Next_b_step |= BIT8;	// align to odd 100 hex
	    } else {		// align to 100 hex
		Next_a_step &= (0x7ff << 8);
		Next_b_step &= (0x7ff << 8);
	    }
	    Next_a_sine_table = SineWave[Next_a_step];
	    Next_b_sine_table = SineWave[Next_b_step];
	    // create scaling values
	    // create half, quarter, eigth, and sixteenth
	    // then combine as required
	    // for non-circular 1/2 step, use full scale
	    if (temp_step_mode == 1)
		Next_full_a = 0xfff;
	    else
		Next_full_a = Next_a_sine_table & Lower_12_bits;
	    Next_half_a = Next_full_a >> 1;
	    Next_quarter_a = Next_full_a >> 2;
	    Next_eighth_a = Next_full_a >> 3;
	    Next_sixteenth_a = Next_full_a >> 4;
	    // 
	    // set full scale for non-circular 1/2step
	    if (temp_step_mode == 1)
		Next_full_b = 0xfff;
	    else
		Next_full_b = Next_b_sine_table & Lower_12_bits;
	    Next_half_b = Next_full_b >> 1;
	    Next_quarter_b = Next_full_b >> 2;
	    Next_eighth_b = Next_full_b > 3;
	    Next_sixteenth_b = Next_full_b >> 4;
	    // determine PHA/PHB setting
	    Next_PHA = Next_a_sine_table & BITD;
	    Next_PHB = Next_b_sine_table & BITD;
	    // now that the values have been captured, adjust them based
	    // on scaling
	    // 
	    switch (tmp_ichop_val) {
	    case 0:		// full scale
		Next_a_value = Next_full_a;
		Next_b_value = Next_full_b;
		break;
	    case 1:		// 93.75 %
		Next_a_value = Next_full_a - Next_sixteenth_a;
		Next_b_value = Next_full_b - Next_sixteenth_b;
		break;
	    case 2:		// 87.5 %
		Next_a_value = Next_full_a - Next_eighth_a;
		Next_b_value = Next_full_b - Next_eighth_b;
		break;
	    case 3:		// 81.25 %
		Next_a_value =
		    Next_full_a - Next_eighth_a - Next_sixteenth_a;
		Next_b_value =
		    Next_full_b - Next_eighth_b - Next_sixteenth_b;
		break;
	    case 4:		// 75 %
		Next_a_value = Next_full_a - Next_quarter_a;
		Next_b_value = Next_full_b - Next_quarter_b;
		break;
	    case 5:		// 68.75 %
		Next_a_value =
		    Next_full_a - Next_quarter_a - Next_sixteenth_a;
		Next_b_value =
		    Next_full_b - Next_quarter_b - Next_sixteenth_b;
		break;
	    case 6:		// 62.5 %
		Next_a_value = Next_half_a + Next_eighth_a;
		Next_b_value = Next_half_b + Next_eighth_b;
		break;
	    case 7:		// 56.25 %
		Next_a_value = Next_half_a + Next_sixteenth_a;
		Next_b_value = Next_half_b + Next_sixteenth_b;
		break;
	    case 8:		// 50 %
		Next_a_value = Next_half_a;
		Next_b_value = Next_half_b;
		break;
	    case 9:		// 43.75 %
		Next_a_value = Next_half_a - Next_sixteenth_a;
		Next_b_value = Next_half_b - Next_sixteenth_b;
		break;
	    case 10:		// 37.5 %
		Next_a_value = Next_half_a - Next_eighth_a;
		Next_b_value = Next_half_b - Next_eighth_b;
		break;
	    case 11:		// 31.25 %
		Next_a_value = Next_quarter_a + Next_sixteenth_a;
		Next_b_value = Next_quarter_b + Next_sixteenth_b;
		break;
	    case 12:		// 25 %
		Next_a_value = Next_quarter_a;
		Next_b_value = Next_quarter_b;
		break;
	    case 13:		// 18.75 %
		Next_a_value = Next_eighth_a + Next_sixteenth_a;
		Next_b_value = Next_eighth_b + Next_sixteenth_b;
		break;
	    case 14:		// 12.5 %
		Next_a_value = Next_eighth_a;
		Next_b_value = Next_eighth_b;
		break;
	    case 15:		// 6.25 %
		Next_a_value = Next_sixteenth_a;
		Next_b_value = Next_sixteenth_b;
		break;
	    }
	    // also capture ena, enb for non-circular
	    if (temp_step_mode == 1) {
		if ((Next_a_sine_table & BITF) == 0)
		    set_ENA_lo;
		else
		    set_ENA_hi;
		if ((Next_b_sine_table & BITF) == 0)
		    set_ENB_lo;
		else
		    set_ENB_hi;
	    } else {		// must set enables high in case of exit
				// from
		// non-circular half step
		set_ENA_hi;
		set_ENB_hi;
	    }

	    DAC12_0DAT = Next_a_value;	// AVREF
	    DAC12_1DAT = Next_b_value;	// BVREF
	    // set the PH outputs
	    if (Next_PHA == 0)
		set_PHA_lo;
	    else
		set_PHA_hi;
	    if (Next_PHB == 0)
		set_PHB_lo;
	    else
		set_PHB_hi;
	}
	// Reload the timers below
	TACCR0 = SteppingRateTMR;	// 
	TACCR2 = SteppingRateTMR >> 1;	// set at 50%
	break;
    case TAIV_TAIFG:
	break;
    }
}


// Watchdog Timer interrupt service routine
#pragma vector=WDT_VECTOR
__interrupt void
watchdog_timer(void)
{
    delay_cycles++;
}
